/* @(#) somx/testobj.cpp 2.4 1/20/94 10:32:13 [5/15/94 17:59:25] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*
#define VARIABLE_MACROS 1
 allows instance data usage of the form _varaible instead of somThis->variable */

#include <stdlib.h>
#include <string.h>

#define REPTestObj_Class_Source
#include "testobj.xih"

char *myname = "TESTOBJ";             /* name of the object */
extern long value_logging;            /* Set in main program */

/* Environment *testobjEnv;*/              /* Environment Ptr for test object */


/*===========================================================================*
 *  Method: SetData                                                          *
 * Purpose: Assign client-passed value to instance variable.                 *
 *===========================================================================*/

SOM_Scope long  SOMLINK somrTestSetData(REPTestObj *somSelf,
                                        Environment *ev, string s)
{
    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrTestSetData");

    if (somThis->mydata) SOMFree(somThis->mydata);

    somThis->mydata = (char*)malloc( strlen(s)+1 );

    if ( somThis->mydata ) {
        if ( !value_logging ) {
            somSelf->somrLockNlogOp (ev, "REPTestObj", "somrTestSetData", ev, s);
            if (ev->_major == NO_EXCEPTION) {
                strcpy( somThis->mydata, s );
                somSelf->somrReleaseNPropagateOperation (ev);
                return 0;
            } else {
                somPrintf("Set Data Failed: LockNlogOp was not successful\n");
                return -1;
            } /* endif - NO_EXCEPTION */
        } else {
            somSelf->somrLock(ev );
            if (ev->_major == NO_EXCEPTION) {
                strcpy( somThis->mydata, s );

                somSelf->somrReleaseNPropagateUpdate(ev, "REPTestObj",
                                                     somThis->mydata,
                                                     strlen(somThis->mydata) + 1,
                                                     0 );
                return 0;
            } else {
                somPrintf("Set Data Failed: Lock was not successful\n");
                return -1;
            } /* endif - NO_EXCEPTION */
        } /* endif - !value_logging */
    } /* endif - mydata */

    somPrintf("Set Data Failed: Unable to allocate memory\n");
    return -1;
}


/*===========================================================================*
 *  Method: TestGetData                                                      *
 * Purpose: Return value of instance variable to client.                     *
 *===========================================================================*/

SOM_Scope string  SOMLINK somrTestGetData(REPTestObj *somSelf,
                                          Environment *ev)
{
    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrTestGetData");

    return (char *) somThis->mydata;
}

/*===========================================================================*
 *  Method:                                                                  *
 * Purpose: Relink object to its peers after it has been unlinked            *
 *          by RepblUninit                                                   *
 *===========================================================================*/

SOM_Scope void  SOMLINK somrPerformRepblInit(REPTestObj *somSelf,
                                               Environment *ev)
{
    long rc;

    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrPerformRepblInit");

    rc = somSelf->somrRepInit(ev,  'o', 'w');

    if (ev->_major == NO_EXCEPTION) {
        somPrintf("Successfully initialized for replication. rc = %d\n", rc );
    } else {
        somPrintf("Initialization for replication failed: rc= %d \n", rc);
    }
}


/*===========================================================================*
 *  Method: RepblUnInit                                                      *
 * Purpose: Unlink object from its peers.                                    *
 *===========================================================================*/

SOM_Scope void  SOMLINK somrPerformRepblUnInit(REPTestObj *somSelf,
                                               Environment *ev)
{
    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrPerformRepblUnInit");

    somSelf->somrRepUninit(ev);

}

/*===========================================================================*
 *  Method: Init                                                             *
 * Purpose: Object Initialization                                            *
 *===========================================================================*/

SOM_Scope void  SOMLINK somInit(REPTestObj *somSelf)
{
    long rc;
    Environment *testobjEnv;

    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somInit");

    REPTestObj_parent_SOMRReplicbl_somInit(somSelf);
    somThis->mydata = NULL;

    testobjEnv = SOM_CreateLocalEnvironment();
    somSelf->somrSetObjName(testobjEnv, myname);

}


/*===========================================================================*
 *  Method: Uninit                                                           *
 * Purpose: Object destructor.                                               *
 *===========================================================================*/

SOM_Scope void  SOMLINK somUninit(REPTestObj *somSelf)
{
    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somUninit");

    if(somThis->mydata) SOMFree(somThis->mydata);

    REPTestObj_parent_SOMRReplicbl_somUninit(somSelf);
}


/*===========================================================================*
 *  Method: DoDirective                                                      *
 * Purpose: Process directives from the replication framework.               *
 *===========================================================================*/

SOM_Scope void  SOMLINK somrDoDirective(REPTestObj *somSelf, Environment *ev,
                string str)
{
    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrDoDirective");

    somPrintf("Directive: %s\n",str);

    REPTestObj_parent_SOMRReplicbl_somrDoDirective(somSelf,ev,str);
}

/*===========================================================================*
 *  Method: ApplyUpdates                                                     *
 * Purpose: Propagate state changes when value logging is used.              *
 *===========================================================================*/

SOM_Scope void  SOMLINK somrApplyUpdates(REPTestObj *somSelf, Environment *ev,
                string buf,
                long len,
                long ObjIntId)
{
    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrApplyUpdates");

    /* REPTestObj_parent_SOMRReplicbl_somrApplyUpdates(somSelf,ev,buf,len,ObjIntId); */

    if (somThis->mydata) SOMFree(somThis->mydata);
    somThis->mydata = (char *)SOMMalloc(len);
    memcpy(somThis->mydata,buf,len);

}

/*===========================================================================*
 *  Method: GetState                                                         *
 * Purpose: Publish current state of master to new shadow objects            *
 *===========================================================================*/

SOM_Scope void  SOMLINK somrGetState(REPTestObj *somSelf, Environment *ev,
                string* buf)
{
    long bufsize;

    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrGetState");

    bufsize = strlen( somThis->mydata ) + 1 + sizeof( long );
    *buf = (char *)SOMMalloc( bufsize );
    strcpy( (char*)(*buf + sizeof( long )), somThis->mydata );
    memcpy( *buf, &bufsize, sizeof( long ) );
}


/*===========================================================================*
 *  Method: SetState                                                         *
 * Purpose: Initialize a shadow object with current state of master.         *
 *===========================================================================*/

SOM_Scope void  SOMLINK somrSetState(REPTestObj *somSelf, Environment *ev,
                string buf)
{
    long len;

    REPTestObjData *somThis = REPTestObjGetData(somSelf);
    REPTestObjMethodDebug("REPTestObj","somrSetState");

    /* REPTestObj_parent_SOMRReplicbl_somrSetState(somSelf,ev,buf);*/

    if(somThis->mydata) SOMFree(somThis->mydata);
    len = *(long *)buf;
    buf += sizeof(long);
    somThis->mydata = (char *)SOMMalloc(len -sizeof(long));
    memcpy(somThis->mydata,buf,len-sizeof(long));

}
